<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2026 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

use function Safe\json_decode;
use function Safe\json_encode;

/**
 * @var DBmysql $DB
 * @var Migration $migration
 */
$events = $DB->request([
    'FROM' => 'glpi_planningexternalevents',
    'WHERE' => [
        'NOT' => ['users_id_guests' => '[]'],
    ],
]);

foreach ($events as $event) {
    $event_id = $event['id'];

    try {
        $guests = json_decode($event['users_id_guests']);
        if (!is_array($guests)) {
            $guests = [];
        }
    } catch (Throwable $e) {
        $guests = [];
    }

    $normalized_guests = [];
    foreach ($guests as $guest) {
        $guest = (int) $guest;
        if ($guest > 0) {
            $normalized_guests[] = $guest;
        }
    }

    $migration->addPostQuery(
        $DB->buildUpdate(
            'glpi_planningexternalevents',
            [
                'users_id_guests' => json_encode($normalized_guests),
            ],
            [
                'id' => $event_id,
            ]
        )
    );
}
