/*!
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2026 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
"use strict";(self["webpackChunk_glpi_glpi"]=self["webpackChunk_glpi_glpi"]||[]).push([[8],{18:e=>{var t=[];function n(e){var n=-1;for(var r=0;r<t.length;r++){if(t[r].identifier===e){n=r;break}}return n}function r(e,r){var a={};var i=[];for(var s=0;s<e.length;s++){var c=e[s];var l=r.base?c[0]+r.base:c[0];var d=a[l]||0;var p="".concat(l," ").concat(d);a[l]=d+1;var u=n(p);var f={css:c[1],media:c[2],sourceMap:c[3],supports:c[4],layer:c[5]};if(u!==-1){t[u].references++;t[u].updater(f)}else{var _=o(f,r);r.byIndex=s;t.splice(s,0,{identifier:p,updater:_,references:1})}i.push(p)}return i}function o(e,t){var n=t.domAPI(t);n.update(e);var r=function t(r){if(r){if(r.css===e.css&&r.media===e.media&&r.sourceMap===e.sourceMap&&r.supports===e.supports&&r.layer===e.layer){return}n.update(e=r)}else{n.remove()}};return r}e.exports=function(e,o){o=o||{};e=e||[];var a=r(e,o);return function e(i){i=i||[];for(var s=0;s<a.length;s++){var c=a[s];var l=n(c);t[l].references--}var d=r(i,o);for(var p=0;p<a.length;p++){var u=a[p];var f=n(u);if(t[f].references===0){t[f].updater();t.splice(f,1)}}a=d}}},19:e=>{function t(e,t,n){var r="";if(n.supports){r+="@supports (".concat(n.supports,") {")}if(n.media){r+="@media ".concat(n.media," {")}var o=typeof n.layer!=="undefined";if(o){r+="@layer".concat(n.layer.length>0?" ".concat(n.layer):""," {")}r+=n.css;if(o){r+="}"}if(n.media){r+="}"}if(n.supports){r+="}"}var a=n.sourceMap;if(a&&typeof btoa!=="undefined"){r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(a))))," */")}t.styleTagTransform(r,e,t.options)}function n(e){if(e.parentNode===null){return false}e.parentNode.removeChild(e)}function r(e){if(typeof document==="undefined"){return{update:function e(){},remove:function e(){}}}var r=e.insertStyleElement(e);return{update:function n(o){t(r,e,o)},remove:function e(){n(r)}}}e.exports=r},20:e=>{var t={};function n(e){if(typeof t[e]==="undefined"){var n=document.querySelector(e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement){try{n=n.contentDocument.head}catch(e){n=null}}t[e]=n}return t[e]}function r(e,t){var r=n(e);if(!r){throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.")}r.appendChild(t)}e.exports=r},21:(e,t,n)=>{function r(e){var t=true?n.nc:0;if(t){e.setAttribute("nonce",t)}}e.exports=r},22:e=>{function t(e){var t=document.createElement("style");e.setAttributes(t,e.attributes);e.insert(t,e.options);return t}e.exports=t},23:e=>{function t(e,t){if(t.styleSheet){t.styleSheet.cssText=e}else{while(t.firstChild){t.removeChild(t.firstChild)}t.appendChild(document.createTextNode(e))}}e.exports=t},25:e=>{e.exports=function(e){var t=e[1];var n=e[3];if(!n){return t}if(typeof btoa==="function"){var r=btoa(unescape(encodeURIComponent(JSON.stringify(n))));var o="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(r);var a="/*# ".concat(o," */");return[t].concat([a]).join("\n")}return[t].join("\n")}},26:e=>{e.exports=function(e){var t=[];t.toString=function t(){return this.map(function(t){var n="";var r=typeof t[5]!=="undefined";if(t[4]){n+="@supports (".concat(t[4],") {")}if(t[2]){n+="@media ".concat(t[2]," {")}if(r){n+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")}n+=e(t);if(r){n+="}"}if(t[2]){n+="}"}if(t[4]){n+="}"}return n}).join("")};t.i=function e(n,r,o,a,i){if(typeof n==="string"){n=[[null,n,undefined]]}var s={};if(o){for(var c=0;c<this.length;c++){var l=this[c][0];if(l!=null){s[l]=true}}}for(var d=0;d<n.length;d++){var p=[].concat(n[d]);if(o&&s[p[0]]){continue}if(typeof i!=="undefined"){if(typeof p[5]==="undefined"){p[5]=i}else{p[1]="@layer".concat(p[5].length>0?" ".concat(p[5]):""," {").concat(p[1],"}");p[5]=i}}if(r){if(!p[2]){p[2]=r}else{p[1]="@media ".concat(p[2]," {").concat(p[1],"}");p[2]=r}}if(a){if(!p[4]){p[4]="".concat(a)}else{p[1]="@supports (".concat(p[4],") {").concat(p[1],"}");p[4]=a}}t.push(p)}};return t}},27:(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t["default"]=(e,t)=>{const n=e.__vccOpts||e;for(const[e,r]of t){n[e]=r}return n}},83:(e,t,n)=>{n.r(t);n.d(t,{default:()=>c});var r=n(84);var o=n(86);var a=n(88);var i=n(27);const s=(0,i["default"])(o["default"],[["render",r.render],["__scopeId","data-v-6d83c4d2"],["__file","js/src/vue/Debug/Widget/ProfilerTable.vue"]]);if(false){}const c=s},84:(e,t,n)=>{n.r(t);n.d(t,{render:()=>r.render});var r=n(85)},85:(e,t,n)=>{n.r(t);n.d(t,{render:()=>u});var r=n(9);const o={class:"table table-striped card-table"};const a=["data-profiler-section-id"];const i={"data-prop":"category"};const s={"data-prop":"name"};const c={"data-prop":"duration"};const l={"data-prop":"percent_of_parent"};const d={"data-prop":"auto_ended"};const p={key:0};function u(e,t,n,u,f,_){const h=(0,r.resolveComponent)("widget-profiler-table");return(0,r.withDirectives)(((0,r.openBlock)(),(0,r.createElementBlock)("table",o,[(0,r.createElementVNode)("thead",null,[(0,r.createElementVNode)("tr",null,[((0,r.openBlock)(true),(0,r.createElementBlock)(r.Fragment,null,(0,r.renderList)(n.nest_level,e=>((0,r.openBlock)(),(0,r.createElementBlock)("th",{class:"nesting-spacer",key:e,"aria-hidden":"true"}))),128)),t[0]||(t[0]=(0,r.createElementVNode)("th",null,"Category",-1)),t[1]||(t[1]=(0,r.createElementVNode)("th",null,"Name",-1)),t[2]||(t[2]=(0,r.createElementVNode)("th",null,"Duration",-1)),t[3]||(t[3]=(0,r.createElementVNode)("th",null,"Percent of parent",-1)),t[4]||(t[4]=(0,r.createElementVNode)("th",null,"Auto-ended",-1))])]),(0,r.createElementVNode)("tbody",null,[((0,r.openBlock)(true),(0,r.createElementBlock)(r.Fragment,null,(0,r.renderList)(u.top_level_data,e=>((0,r.openBlock)(),(0,r.createElementBlock)(r.Fragment,null,[(0,r.withDirectives)((0,r.createElementVNode)("tr",{"data-profiler-section-id":e.id},[((0,r.openBlock)(true),(0,r.createElementBlock)(r.Fragment,null,(0,r.renderList)(n.nest_level,e=>((0,r.openBlock)(),(0,r.createElementBlock)("td",{class:"nesting-spacer",key:e,"aria-hidden":"true"}))),128)),(0,r.createElementVNode)("td",i,[(0,r.createElementVNode)("span",{class:"category-badge badge badge-outline fw-bold border-2",style:(0,r.normalizeStyle)(`border-color: ${e.bg_color};`)},(0,r.toDisplayString)(e.category),5)]),(0,r.createElementVNode)("td",s,(0,r.toDisplayString)(e.name),1),(0,r.createElementVNode)("td",c,(0,r.toDisplayString)(e.duration.toFixed(0))+" ms",1),(0,r.createElementVNode)("td",l,(0,r.toDisplayString)(e.percent_of_parent)+"%",1),(0,r.createElementVNode)("td",d,(0,r.toDisplayString)(e.auto_ended?"Yes":"No"),1)],8,a),[[r.vShow,!u.props.hide_instant_sections||e.duration>u.instant_threshold]]),e.has_children?(0,r.withDirectives)(((0,r.openBlock)(),(0,r.createElementBlock)("tr",p,[(0,r.createElementVNode)("td",{colspan:u.col_count},[(0,r.createVNode)(h,{parent_duration:e.duration,nest_level:u.props.nest_level+1,profiler_sections:u.props.profiler_sections,parent_id:e.id,hide_instant_sections:u.props.hide_instant_sections},null,8,["parent_duration","nest_level","profiler_sections","parent_id","hide_instant_sections"])])],512)),[[r.vShow,!u.props.hide_instant_sections||e.duration>u.instant_threshold]]):(0,r.createCommentVNode)("v-if",true)],64))),256))])],512)),[[r.vShow,u.hasUnfilteredSections(u.top_level_data)]])}},86:(e,t,n)=>{n.r(t);n.d(t,{default:()=>r["default"]});var r=n(87)},87:(e,t,n)=>{n.r(t);n.d(t,{default:()=>a});var r=n(9);const o=1;const a={__name:"ProfilerTable",props:{parent_id:{type:String,required:false},profiler_sections:{type:Array,required:true},nest_level:{type:Number,required:true,default:0},parent_duration:{type:Number,required:true,default:0},hide_instant_sections:{type:Boolean,required:false,default:false}},setup(e,{expose:t}){t();const n=e;function a(e){const t={core:"#89a2e1",db:"#9252ad",twig:"#64ad52",plugins:"#a077a6",search:"#b6803d",boot:"#a24e55"};let n="";if(t[e]!==undefined){n=t[e]}else{let t=0;for(let n=0;n<e.length;n++){t=e.charCodeAt(n)+((t<<5)-t)}let r="#";for(let e=0;e<3;e++){const n=t>>e*8&255;r+=("00"+n.toString(16)).substr(-2)}n=r}return{bg_color:n}}const i=5+n.nest_level;function s(e){const t=n.profiler_sections.filter(t=>t.parent_id===e);const r=[];for(let e=0;e<t.length;e++){const o=t[e];const i=a(o.category);const s=o.duration||o.end-o.start;let c=100;if(n.nest_level>0&&n.parent_duration>0){c=(s/n.parent_duration*100).toFixed(2)}else if(n.parent_duration<=0){c=(100/t.length).toFixed(2)}const l={id:o.id,name:_.escape(o.name),category:_.escape(o.category),bg_color:i.bg_color,start:o.start,end:o.end,duration:s,percent_of_parent:c,has_children:n.profiler_sections.filter(e=>e.parent_id===o.id).length>0,auto_ended:o.auto_ended||false};r.push(l)}return r}const c=(0,r.computed)(()=>s(n.parent_id));function l(e){if(!n.hide_instant_sections){return true}for(let t=0;t<e.length;t++){const n=e[t];if(n.duration>o){return true}}return false}const d={props:n,getProfilerCategoryColor:a,col_count:i,getProfilerData:s,top_level_data:c,instant_threshold:o,hasUnfilteredSections:l,computed:r.computed};Object.defineProperty(d,"__isScriptSetup",{enumerable:false,value:true});return d}}},88:(e,t,n)=>{n.r(t);var r=n(89)},89:(e,t,n)=>{n.r(t);n.d(t,{default:()=>m});var r=n(18);var o=n.n(r);var a=n(19);var i=n.n(a);var s=n(20);var c=n.n(s);var l=n(21);var d=n.n(l);var p=n(22);var u=n.n(p);var f=n(23);var _=n.n(f);var h=n(90);var v={};v.styleTagTransform=_();v.setAttributes=d();v.insert=c().bind(null,"head");v.domAPI=i();v.insertStyleElement=u();var g=o()(h["default"],v);const m=h["default"]&&h["default"].locals?h["default"].locals:undefined},90:(e,t,n)=>{n.r(t);n.d(t,{default:()=>c});var r=n(25);var o=n.n(r);var a=n(26);var i=n.n(a);var s=i()(o());s.push([e.id,`\n.nesting-spacer[data-v-6d83c4d2] {\n        min-width: 2rem;\n}\n.category-badge[data-v-6d83c4d2] {\n        color: var(--tblr-body-color);\n}\n`,"",{version:3,sources:["webpack://./js/src/vue/Debug/Widget/ProfilerTable.vue"],names:[],mappings:";AAwJI;QACI,eAAe;AACnB;AACA;QACI,6BAA6B;AACjC",sourcesContent:['<script setup>\n    /* global tinycolor */\n    /* global _ */\n    import {computed} from "vue";\n\n    const props = defineProps({\n        parent_id: {\n            type: String,\n            required: false,\n        },\n        profiler_sections: {\n            type: Array,\n            required: true,\n        },\n        nest_level: {\n            type: Number,\n            required: true,\n            default: 0,\n        },\n        parent_duration: {\n            type: Number,\n            required: true,\n            default: 0,\n        },\n        hide_instant_sections: {\n            type: Boolean,\n            required: false,\n            default: false,\n        }\n    });\n\n    function getProfilerCategoryColor(category) {\n        const predefined_colors = {\n            core: \'#89a2e1\',\n            db: \'#9252ad\',\n            twig: \'#64ad52\',\n            plugins: \'#a077a6\',\n            search: \'#b6803d\',\n            boot: \'#a24e55\',\n        };\n\n        let bg_color = \'\';\n        if (predefined_colors[category] !== undefined) {\n            bg_color = predefined_colors[category];\n        } else {\n            let hash = 0;\n            for (let i = 0; i < category.length; i++) {\n                hash = category.charCodeAt(i) + ((hash << 5) - hash);\n            }\n            let color = \'#\';\n            for (let i = 0; i < 3; i++) {\n                const value = (hash >> (i * 8)) & 0xFF;\n                color += (\'00\' + value.toString(16)).substr(-2);\n            }\n            bg_color = color;\n        }\n\n        return {\n            bg_color: bg_color,\n        };\n    }\n\n    const col_count = 5 + props.nest_level;\n\n    function getProfilerData(parent_id) {\n        const sections = props.profiler_sections.filter((section) => section.parent_id === parent_id);\n        const sections_data = [];\n        for (let i = 0; i < sections.length; i++) {\n            const section = sections[i];\n            const cat_colors = getProfilerCategoryColor(section.category);\n            const duration = section.duration || (section.end - section.start);\n            let percent_of_parent = 100;\n            if (props.nest_level > 0 && props.parent_duration > 0) {\n                percent_of_parent = ((duration / props.parent_duration) * 100).toFixed(2);\n            } else if (props.parent_duration <= 0) {\n                percent_of_parent = (100 / sections.length).toFixed(2);\n            }\n\n            const data = {\n                id: section.id,\n                name: _.escape(section.name),\n                category: _.escape(section.category),\n                bg_color: cat_colors.bg_color,\n                start: section.start,\n                end: section.end,\n                duration: duration,\n                percent_of_parent: percent_of_parent,\n                has_children: props.profiler_sections.filter((child) => child.parent_id === section.id).length > 0,\n                auto_ended: section.auto_ended || false,\n            };\n            sections_data.push(data);\n        }\n        return sections_data;\n    }\n    const top_level_data = computed(() => {\n        return getProfilerData(props.parent_id);\n    });\n\n    const instant_threshold = 1.0;\n\n    function hasUnfilteredSections(sections) {\n        if (!props.hide_instant_sections) {\n            return true;\n        }\n        for (let i = 0; i < sections.length; i++) {\n            const section = sections[i];\n            if (section.duration > instant_threshold) {\n                return true;\n            }\n        }\n        return false;\n    }\n<\/script>\n\n<template>\n    <table class="table table-striped card-table" v-show="hasUnfilteredSections(top_level_data)">\n        <thead>\n            <tr>\n                <th class="nesting-spacer" v-for="i in nest_level" :key="i" aria-hidden="true"></th>\n                <th>Category</th>\n                <th>Name</th>\n                <th>Duration</th>\n                <th>Percent of parent</th>\n                <th>Auto-ended</th>\n            </tr>\n        </thead>\n        <tbody>\n            <template v-for="section in top_level_data">\n                <tr :data-profiler-section-id="section.id" v-show="!props.hide_instant_sections || (section.duration > instant_threshold)">\n                    <td class="nesting-spacer" v-for="i in nest_level" :key="i" aria-hidden="true"></td>\n                    <td data-prop="category">\n                        <span class="category-badge badge badge-outline fw-bold border-2" :style="`border-color: ${section.bg_color};`">\n                            {{ section.category }}\n                        </span>\n                    </td>\n                    <td data-prop="name">{{ section.name }}</td>\n                    <td data-prop="duration">{{ section.duration.toFixed(0) }} ms</td>\n                    <td data-prop="percent_of_parent">{{ section.percent_of_parent }}%</td>\n                    <td data-prop="auto_ended">{{ section.auto_ended ? \'Yes\' : \'No\' }}</td>\n                </tr>\n                <tr v-if="section.has_children" v-show="!props.hide_instant_sections || (section.duration > instant_threshold)">\n                    <td :colspan="col_count">\n                        <widget-profiler-table :parent_duration="section.duration" :nest_level="props.nest_level + 1"\n                                               :profiler_sections="props.profiler_sections" :parent_id="section.id" :hide_instant_sections="props.hide_instant_sections"></widget-profiler-table>\n                    </td>\n                </tr>\n            </template>\n        </tbody>\n    </table>\n</template>\n\n<style scoped>\n    .nesting-spacer {\n        min-width: 2rem;\n    }\n    .category-badge {\n        color: var(--tblr-body-color);\n    }\n</style>\n'],sourceRoot:""}]);const c=s}}]);