/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2026 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
import{GlpiFormConditionVisibilityEditorController}from"/js/modules/Forms/ConditionVisibilityEditorController.js";import{GlpiFormConditionValidationEditorController}from"/js/modules/Forms/ConditionValidationEditorController.js";export class GlpiFormEditorController{#t;#e;#i;#o;#n;#a;#s;#d;#r=false;#l=false;constructor(t,e,i,o,n,a){this.#t=t;this.#e=e;this.#i=i;this.#o=o;this.#n=n;this.#a={};this.#s={};this.#d=[];this.#l=a;if($(this.#t).prop("tagName")!="FORM"){throw new Error("Target must be a valid form")}this.#c();this.#p();this.#m();this.#f();if(!this.#l){if(this.#g(this.#i).length==0){throw new Error(`Invalid default question type: ${i}`)}this.#h($(this.#t).find("[data-glpi-form-editor-blocks]"));if(this.#u()===0){$(this.#t).find("[data-glpi-form-editor-form-details-name]")[0].select()}}this.computeState();this.#b()}#f(){$(this.#t).on("mousedown","[data-glpi-form-radio-uncheckable]",function(){const t=$(this);if(t.is(":checked")){t.data("was-checked",true)}else{t.data("was-checked",false)}});$(this.#t).on("click","[data-glpi-form-radio-uncheckable]",function(){const t=$(this);if(t.data("was-checked")){t.prop("checked",false);t.data("was-checked",false);t.trigger("change")}})}#p(){const t=_.throttle(()=>this.#c(),100);$(window).on("resize",()=>t());$(this.#t).on("glpi-ajax-controller-submit-success",()=>this.#$());$(document).on("click","[data-glpi-form-editor]",()=>{$(".simulate-focus").removeClass("simulate-focus")});$(document).on("tinyMCEChange",(t,e)=>this.#v(e));$(document).on("tinyMCEClick",(t,e)=>this.#y(e));$(document).on("show.bs.dropdown","[data-glpi-form-editor-visibility-dropdown]",t=>this.#k($(t.target).parent().find("[data-glpi-conditions-editor-container]")));$(document).on("show.bs.dropdown","[data-glpi-form-editor-validation-dropdown]",t=>this.#C($(t.target).parent().find("[data-glpi-conditions-editor-container]")));$(this.#t).on("submit",t=>{try{t.originalEvent.submitter.focus();this.computeState()}catch(e){t.preventDefault();t.stopPropagation();glpi_toast_error(__("An unexpected error occurred"));throw e}});$(this.#t).on("glpi-ajax-controller-submit-success",()=>{const t=$(this.#t).find("[data-glpi-form-editor-save-and-preview-action]");this.#S();if(this.#r){window.open(t.data("glpi-form-editor-preview-url"),"_blank");this.#r=false}});$(document).on("glpiFormChangeEvent",()=>{this.#S()});document.addEventListener("updated_strategy",t=>{this.#I($(t.detail.container).closest("[data-glpi-form-editor-block],[data-glpi-form-editor-section-details],[data-glpi-form-editor-container]"),t.detail.strategy)});document.addEventListener("conditions_count_changed",t=>{this.#_($(t.detail.container).closest("[data-glpi-form-editor-block],[data-glpi-form-editor-section-details],[data-glpi-form-editor-container]"),t.detail.conditions_count)});$(document).on("select2:selecting",t=>{$(t.target).data("previous-value",$(t.target).val())});const e=["click","change","input"];e.forEach(t=>{const e=`data-glpi-form-editor-on-${t}`;$(document).on(t,`${this.#t} [${e}]`,async t=>{const i=$(t.currentTarget);const o=i.attr(e);try{await this.#w(o,i,t)}catch(t){glpi_toast_error(__("An unexpected error occurred"));throw t}})})}registerQuestionTypeOptions(t,e){this.#a[t]=e}registerQuestionSubTypesOptions(t,e){this.#s[t]=e}#$(){if(this.#e){this.#q()}}async#w(t,e,i){let o=true;i.stopPropagation();switch(t){case"set-active":this.#E(e);o=false;break;case"add-question":this.#z(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment],\n                        [data-glpi-form-editor-horizontal-block-placeholder]\n                    `));break;case"delete-question":this.#U(e.closest("[data-glpi-form-editor-question]"));break;case"change-question-type-category":await this.#T(e.closest("[data-glpi-form-editor-question]"),e.val());break;case"change-question-type":await this.#D(e.closest("[data-glpi-form-editor-question]"),e.val());break;case"change-question-sub-type":this.#A(e.closest("[data-glpi-form-editor-question]"),e.val());break;case"add-section":this.#x(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment]\n                    `));break;case"delete-section":this.#F(e.closest("[data-glpi-form-editor-section]"));break;case"build-move-section-modal-content":this.#Q();o=false;break;case"reorder-sections":this.#B();break;case"merge-with-previous-section":this.#M(e.closest("[data-glpi-form-editor-section]"));break;case"collapse-section":this.#V(e.closest("[data-glpi-form-editor-section]"));break;case"duplicate-section":this.#H(e.closest("[data-glpi-form-editor-section]"));break;case"duplicate-question":this.#L(e.closest("[data-glpi-form-editor-question]"));break;case"duplicate-comment":this.#O(e.closest("[data-glpi-form-editor-comment]"));break;case"question-sort-update":break;case"add-comment":this.#j(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment],\n                        [data-glpi-form-editor-horizontal-block-placeholder]\n                    `));break;case"delete-comment":this.#N(e.closest("[data-glpi-form-editor-comment]"));break;case"show-visibility-dropdown":this.#P(e.closest("[data-glpi-form-editor-block],[data-glpi-form-editor-section-details]"));break;case"show-validation-dropdown":this.#R(e.closest("[data-glpi-form-editor-block],[data-glpi-form-editor-section-details]"));break;case"add-horizontal-layout":this.#G(e.closest(`\n                        [data-glpi-form-editor-active-form],\n                        [data-glpi-form-editor-active-section],\n                        [data-glpi-form-editor-active-horizontal-blocks],\n                        [data-glpi-form-editor-active-question],\n                        [data-glpi-form-editor-active-comment]\n                    `));break;case"delete-horizontal-layout":this.#X(e.closest("[data-glpi-form-editor-horizontal-blocks-container]"));break;case"add-horizontal-layout-slot":this.#J(e.closest("[data-glpi-form-editor-horizontal-blocks]"));break;case"remove-horizontal-layout-slot":this.#W(e.closest("[data-glpi-form-editor-horizontal-block-placeholder]"));break;case"copy-uuid":this.#K(e.closest("[data-glpi-form-editor-question"));break;case"queue-preview":this.#r=true;break;case"stop-propagation":break;default:throw new Error(`Unknown action: ${t}`)}if(o){setHasUnsavedChanges(true)}this.#m()}computeState(){const t={question:0,comment:0};const e=$(this.#t).find("[data-glpi-form-editor-section]");e.each((e,i)=>{this.#Y($(i).find("[data-glpi-form-editor-section-details]"),"section",e);this.#Z($(i),e);this.#tt($(i));const o=$(i).find("[data-glpi-form-editor-section-blocks]").children("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-blocks-container]");o.each((e,o)=>{let n=$(o);const a=$(o).is("[data-glpi-form-editor-horizontal-blocks-container]");if(a){n=$(o).find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]")}n.each((o,n)=>{if($(n).is("[data-glpi-form-editor-horizontal-block-placeholder]")){return}const s=$(n).is("[data-glpi-form-editor-question]")?"question":"comment";this.#Y($(n),s,t[s]);this.#et($(n),e,a?o:-1);this.#tt($(n));this.#it($(n),$(i));t[s]++})})})}#m(){this.#ot();this.#nt();this.#at();this.#st()}#Y(t,e,i){const o=t.find("input[name], select[name], textarea[name]");o.each((t,o)=>{const n=$(o).attr("name");if(!$(o).data("glpi-form-editor-original-name")){$(o).attr("data-glpi-form-editor-original-name",n)}let a=$(o).data("glpi-form-editor-original-name");let s="";if(e==="section"){s=`_sections[${i}]`}else if(e==="question"){s=`_questions[${i}]`;const t=$(o).attr("data-glpi-form-editor-specific-question-extra-data")!==undefined;if(t){s+=`[extra_data]`}}else if(e==="comment"){s=`_comments[${i}]`}else if(e==="temp"){s=`_temp[${i}]`}else{throw new Error(`Unknown item type: ${e}`)}let d="";const r=new RegExp(/\[([\w-[\]]*)\]$/,"g");if(typeof a==="string"&&r.test(a)){d=a.match(r);a=a.replace(d,"")}$(o).attr("name",`${s}[${a}]${d}`);if($(o).attr("data-form-data")){const t=$(o).attr("name");if($(o).data("blueimp-fileupload")!==undefined){$(o).fileupload("option","formData").name=t}const e=JSON.parse($(o).attr("data-form-data"));e.name=t;$(o).attr("data-form-data",JSON.stringify(e))}})}#Z(t,e){this.#dt(t,"rank",e)}#et(t,e,i=null){this.#dt(t,"vertical_rank",e);this.#dt(t,"horizontal_rank",i);const o=t.find("input[name='horizontal_rank'], input[data-glpi-form-editor-original-name='horizontal_rank']");o.prop("disabled",i===null)}#tt(t){const e=this.#rt(t,"uuid");if(e==""){this.#dt(t,"uuid",getUUID())}}#it(t,e){const i=this.#rt(e,"uuid");this.#dt(t,"forms_sections_uuid",i)}#v(t){const e=$(t.target.container).closest("[data-glpi-form-editor-question-description]");if(e.length>0){this.#lt(e,t.level.content)}}#y(t){const e=$(t.target).closest("html").find("body");const i=e.closest("#tinymce").data("id");const o=$(`#${i}`);this.#E(o.closest('[data-glpi-form-editor-on-click="set-active"]'))}#c(){const t=document.body.offsetHeight;const e=$(this.#t).offset().top;const i=1;let o=t-e-i;if($("#debug-toolbar").length>0){const t=$("#debug-toolbar").height();o-=t}$(this.#t).css("height",`${o}`)}#q(){const t=$("#main-form button[name=update]");t.find(".ti-plus").removeClass("ti-plus").addClass("ti-device-floppy");t.find(".add-label").text(_.unescape(__("Save")));t.prop("title",_.unescape(__("Save")));const e=$("#main-form button[name=delete]");e.removeClass("d-none");this.#e=false}#lt(t,e){const i=document.createElement("div");i.innerHTML=e;const o=i.textContent||i.innerText||"";const n=o.length;if(n==0){t.attr("data-glpi-form-editor-question-extra-details","")}else{t.removeAttr("data-glpi-form-editor-question-extra-details")}}#E(t){const e=["form","section","question","comment","horizontal-blocks","horizontal-block-placeholder"];e.forEach(e=>{$(this.#t).find(`[data-glpi-form-editor-active-${e}]`).filter((i,o)=>{if(e==="form"||e==="section"){return true}return t===null||!$(o).is(t)&&$(o).has(t).length===0}).removeAttr(`data-glpi-form-editor-active-${e}`)});if(t===null){return}t.find("select[data-glpi-loaded=false]").each(function(){const t=$(this).attr("id");const e=window.select2_configs[t];if(e.type==="ajax"){setupAjaxDropdown(e)}else if(e.type==="adapt"){setupAdaptDropdown(e)}$(this).attr("data-glpi-loaded","true")});setTimeout(()=>{if(t!==null){e.forEach(e=>{e=CSS.escape(e);if(t.data(`glpi-form-editor-${e}-details`)!==undefined){t.closest(`[data-glpi-form-editor-${e}]`).attr(`data-glpi-form-editor-active-${e}`,"")}else if(t.data(`glpi-form-editor-${e}`)!==undefined){t.attr(`data-glpi-form-editor-active-${e}`,"")}});const i=t.closest("[data-glpi-form-editor-section]");if(i.hasClass("section-collapsed")){return}t.addClass("active");const o=t.closest("section[data-glpi-form-editor-horizontal-blocks]");if(o.length>0){o.closest("section[data-glpi-form-editor-horizontal-blocks-container]").attr("data-glpi-form-editor-active-horizontal-blocks","")}if(t.length>0){this.#ct(t)}}})}#pt(t,e){let i;let o;if(t.data("glpi-form-editor-question")!==undefined||t.data("glpi-form-editor-comment")!==undefined){i=t;o="after"}else if(t.data("glpi-form-editor-section")!==undefined){i=t.closest("[data-glpi-form-editor-section]").find("[data-glpi-form-editor-section-blocks]");o="prepend"}else if(t.data("glpi-form-editor-form")!==undefined){i=$(this.#t).find("[data-glpi-form-editor-section]:last-child").find("[data-glpi-form-editor-section-blocks]:last-child");o="append"}else if(t.data("glpi-form-editor-horizontal-blocks-container")!==undefined){i=t;o="after"}else if(t.data("glpi-form-editor-horizontal-blocks")!==undefined){i=t;o="append"}else if(t.data("glpi-form-editor-horizontal-block-placeholder")!==undefined){i=t;o="after";setTimeout(()=>this.#W(t),0)}else{throw new Error("Unexpected target")}return this.#mt(e,i,o)}#z(t){const e=this.#g(this.#i).children();const i=this.#pt(t,e);this.#tt(i);this.#E(i);i.find("[data-glpi-form-editor-question-details-name]")[0].focus();this.#h(i)}#U(t){if(!this.#ft("question",t)){return}t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");if($(this.#t).find("[data-glpi-form-editor-question]").length==1&&this.#gt()==1){this.#ht()}else{if(t.prev().length>0){this.#E(t.prev())}else{this.#E(t.closest("[data-glpi-form-editor-section]"))}}const e=t.parent();t.remove();if(e.is("[data-glpi-form-editor-horizontal-blocks]")&&e.find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length===0){this.#X(e)}}#ut(t,e){const i=this.#rt(e,"uuid");if(!i){return{conditionsUsingItem:[],destinationsUsingItem:[]}}const o=`${t}-${i}`;const n=$("[data-glpi-form-editor-form] [data-glpi-conditions-editor-item]").filter((e,n)=>{if(n.value!==o){return false}let a;if(t==="section"){a=$(n).closest("[data-glpi-form-editor-section]")}else{a=$(n).closest("[data-glpi-form-editor-block]")}if(a.length!==1){return false}if(this.#rt(a,"uuid")===i){return false}return true});const a=Object.values(this.#n).filter(t=>t.conditions&&Object.values(t.conditions).some(t=>t.item===o));const s=$("[data-glpi-form-editor-submit-button-conditional-visibility-field]").find("[data-glpi-conditions-editor-item]").filter((t,e)=>e.value===o).length>0;return{conditionsUsingItem:n,destinationsUsingItem:a,itemUsedBySubmitButton:s}}#ft(t,e){const i=this.#ut(t,e);if(i.conditionsUsingItem.length>0||i.destinationsUsingItem.length>0||i.itemUsedBySubmitButton){this.#bt(t,i.conditionsUsingItem,i.destinationsUsingItem,i.itemUsedBySubmitButton,"deletion");return false}return true}async#$t(t){try{const e=await $.ajax({url:`${CFG_GLPI.root_doc}/Form/Condition/Editor/SupportedValueOperators`,method:"POST",contentType:"application/json",data:JSON.stringify(t)});return e.operators||[]}catch(t){console.error("Error fetching supported value operators:",t);return[]}}async#vt(t,e){const i=this.#ut("question",t);const o={type:e,uuid:this.#rt(t,"uuid"),name:this.#rt(t,"name")||"",extra_data:this.#yt(t[0])};const n=await this.#$t(o);const a=i.conditionsUsingItem.filter((t,e)=>!n.includes($(e).closest("[data-glpi-conditions-editor-condition]").find("[data-glpi-conditions-editor-value-operator]").val()));const s=i.destinationsUsingItem.filter(t=>t.conditions&&Object.values(t.conditions).some(t=>{if(t.item!==`question-${o.uuid}`){return false}return!n.includes(t.value_operator)}));const d=i.itemUsedBySubmitButton&&$("[data-glpi-form-editor-submit-button-conditional-visibility-field]").find("[data-glpi-conditions-editor-condition]").filter((t,e)=>{const i=$(e).find("[data-glpi-conditions-editor-item]").val();if(i!==`question-${o.uuid}`){return false}const a=$(e).find("[data-glpi-conditions-editor-value-operator]").val();return!n.includes(a)}).length>0;if(a.length>0||s.length>0||d){this.#bt("question",a,s,d,"new_question_type");return false}return true}#bt(t,e,i,o,n){$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(n)}"] [data-glpi-form-editor-item-has-conditions-modal-header]`).addClass("d-none").filter(`[data-glpi-form-editor-item-has-conditions-modal-header="${CSS.escape(t)}"]`).removeClass("d-none");const a=[];const s=[];e.each((t,e)=>{const i=$(e).closest("[data-glpi-form-editor-block]");if(i.length>0){const t=this.#rt(i,"uuid");if(s.indexOf(t)!=-1){return}a.push({name:this.#rt(i,"name"),uuid:t,type:"question",element:i});s.push(t)}else{const t=$(e).closest("[data-glpi-form-editor-section]");if(t.length>0){const e=this.#rt(t,"uuid");if(s.indexOf(e)!=-1){return}a.push({name:this.#rt(t,"name"),uuid:e,type:"section",element:t});s.push(e)}}});i.forEach(t=>{a.push({name:t.name,type:"destination"})});if(o){a.push({name:__("Submit button visibility"),type:"submit-button"})}const d=$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(n)}"] [data-glpi-form-editor-item-has-conditions-list]`);d.empty();const r=$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(n)}"] [data-glpi-form-editor-item-has-conditions-item-template]`).html();a.forEach(t=>{const e=$(r);const i=e.find("[data-glpi-form-editor-item-has-conditions-item-name]");i.text(t.name);if(t.uuid){i.attr("data-glpi-form-editor-item-has-conditions-item-uuid",t.uuid)}i.attr("data-glpi-form-editor-item-has-conditions-item-type",t.type);if(t.type==="destination"){const t=$('[data-bs-target^="#tab-Glpi_Form_Destination_FormDestination_"]');i.attr("href",t.attr("href"))}d.append(e)});d.find('[data-glpi-form-editor-item-has-conditions-item-selector][href="#"]').on("click",t=>{t.preventDefault();$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(n)}"]`).modal("hide");const e=$(t.currentTarget);const i=e.data("glpi-form-editor-item-has-conditions-item-uuid");const o=e.data("glpi-form-editor-item-has-conditions-item-type");this.#kt(o,i)});$(`[data-glpi-form-editor-item-has-conditions-modal="${CSS.escape(n)}"]`).modal("show")}#kt(t,e){if(!t){return}if(e){let i;if(t==="question"||t==="comment"){i=$(this.#t).find("[data-glpi-form-editor-block]").filter((t,i)=>this.#rt($(i),"uuid")===e).first()}else if(t==="section"){i=$(this.#t).find("[data-glpi-form-editor-section-details]").filter((t,i)=>this.#rt($(i),"uuid")===e).first()}if(i&&i.length>0){const t=i.closest("[data-glpi-form-editor-section]");if(t.hasClass("section-collapsed")){this.#V(t)}this.#E(i);i.get(0).scrollIntoView({behavior:"smooth",block:"center",inline:"nearest"})}}else if(t==="submit-button"){setTimeout(()=>{$("[data-glpi-form-editor-visibility-dropdown]").dropdown("show")})}}#g(t){return $(this.#o).find(`[data-glpi-form-editor-question-template="${CSS.escape(t)}"]`)}#mt(t,e,i="append",o=false){const n=t.clone();const a=[];const s=[];const d=[];n.find("textarea").each(function(){let t=$(this).attr("id");const e=_.cloneDeep(window.tinymce_editor_configs[t]);const i=getUUID();$(this).attr("id",`_tinymce_${i}`);for(const e in window.fileupload_configs){const o=window.fileupload_configs[e];if(o.editor_id===t){o.editor_id=`_tinymce_${i}`;window.fileupload_configs[e]=o}}t=$(this).attr("id");e.selector=`#${CSS.escape(t)}`;window.tinymce_editor_configs[t]=e;const o=$(this).parent().find("div[data-glpi-tinymce-init-on-demand-render]");if(o.length>0){o.attr("data-glpi-tinymce-init-on-demand-render",t)}else{a.push(e)}});n.find("select").each(function(){let e;if(o&&$(this).hasClass("select2-hidden-accessible")){e=$(this).select2("data");$(this).removeClass("select2-hidden-accessible");$(this).removeAttr("data-select2-id");$(this).next(".select2-container").remove();t.find(`#${CSS.escape($(this).attr("id"))}`).each(function(){const t=$(this).attr("data-glpi-form-editor-original-id")??$(this).attr("id");const i={...window.select2_configs[t]};i.field_id=$(this).attr("id");s.push(i);d[$(this).attr("id")]=e;$(this).select2("destroy")})}const i=$(this).attr("data-glpi-form-editor-original-id")??$(this).attr("id");const a={...window.select2_configs[i]};if(i!==undefined&&a!==undefined){const t=getUUID();const o=`_config_${t}`;$(this).attr("id",o);$(this).attr("data-glpi-form-editor-original-id",i);if(n.find(`label[for="${CSS.escape(i)}"]`).length>0){n.find(`label[for="${CSS.escape(i)}"]`).attr("for",o)}if($(this).hasClass("select2-hidden-accessible")===false&&a!==undefined){a.field_id=o;window.select2_configs[o]=a;if($(this).attr("data-glpi-loaded")!=="false"){s.push(a);if(e){d[o]=e}}}}});if(o){this.#Y(n,"temp",getUUID())}n.find("input[id]").each(function(){const t=$(this).attr("id");const e=n.find(`label[for="${CSS.escape(t)}"]`);if(e.length==0){return}const i=getUUID();const o=`${t}_${i}`;$(this).attr("id",o);e.each(function(){$(this).attr("for",o)})});n.find("div.fileupload > input[id][data-form-data]").each(function(){const t=$(this).attr("id");const e=getUUID();const i=`${t}_${e}`;$(this).attr("id",i);const o=window.fileupload_configs[t];if(o!==undefined){window.fileupload_configs[i]=o;window.fileupload_configs[i].field_id=i}});switch(i){case"append":n.appendTo(e);break;case"prepend":n.prependTo(e);break;case"before":n.insertBefore(e);break;case"after":n.insertAfter(e);break;default:throw new Error(`Unknown action: ${i}`)}a.forEach(t=>tinyMCE.init(t));s.forEach(t=>{if(t.type==="ajax"){const e=setupAjaxDropdown(t);if(d[t.field_id]){e.find("option").remove();for(const i of d[t.field_id]){const t=new Option(i.text,i.id,true,true);e.append(t).trigger("change");e.trigger("select2:select",{data:i})}}}else if(t.type==="adapt"){const e=setupAdaptDropdown(t);if(d[t.field_id]){for(const i of d[t.field_id]){e.val(i.id).trigger("change")}}}});const r=n.find('[data-bs-toggle="tooltip"]');[...r].map(t=>new bootstrap.Tooltip(t));const l=n.find('[data-bs-toggle="popover"]');[...l].map(t=>new bootstrap.Popover(t));this.computeState();return n}#yt(t){const e={};const i=t.querySelectorAll("[data-glpi-form-editor-specific-question-extra-data]");for(const t of i){if(t.type==="checkbox"&&t.checked===false){continue}let i=t.dataset.glpiFormEditorOriginalName;if(i===undefined){i=t.name}const o=i.indexOf("[")!==-1&&i.indexOf("]")!==-1&&i.indexOf("[]")===-1;if(o){const o=i.match(/^(.*)\[(.*)\]$/);if(o===null){throw new Error(`Unexpected input name: ${i}`)}if(e[o[1]]===undefined){e[o[1]]={}}e[o[1]][o[2]]=t.value}else{e[i]=t.value}}return e}#rt(t,e){if(t.data("glpi-form-editor-section")!==undefined){t=t.find("[data-glpi-form-editor-section-details]")}let i=t.find(`input[name="${CSS.escape(e)}"]`);if(i.length>0){return t.find(`input[name="${CSS.escape(e)}"]`).val()}i=t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`);if(i.length>0){return t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`).val()}throw new Error(`Field not found: ${e}`)}#dt(t,e,i){if(t.data("glpi-form-editor-section")!==undefined){t=t.find("[data-glpi-form-editor-section-details]")}let o=t.find(`input[name="${CSS.escape(e)}"]`);if(o.length>0){return t.find(`input[name="${CSS.escape(e)}"]`).val(i)}o=t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`);if(o.length>0){return t.find(`input[data-glpi-form-editor-original-name="${CSS.escape(e)}"]`).val(i)}throw new Error(`Field not found: ${e}`)}setQuestionTypeSpecificLoadingState(t,e){const i=t.find("[data-glpi-form-editor-question-type-specific]");if(e){if(i.find(".glpi-form-editor-loading-overlay").length===0){const t=$(`\n                    <div class="glpi-form-editor-loading-overlay position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75">\n                        <div class="spinner-border spinner-border-sm text-secondary" role="status">\n                            <span class="visually-hidden">${__("Loading...")}</span>\n                        </div>\n                    </div>\n                `);i.css("position","relative").append(t)}i.css({opacity:"0.7","pointer-events":"none"}).attr("data-glpi-loading","true")}else{i.find(".glpi-form-editor-loading-overlay").remove();i.css({opacity:"","pointer-events":"",position:""}).removeAttr("data-glpi-loading")}}async#T(t,e){const i=this.#rt(t,"category");if(i===e){return}const o=$(this.#o).find(`option[data-glpi-form-editor-question-type="${CSS.escape(e)}"]`);this.setQuestionTypeSpecificLoadingState(t,true);if(!await this.#vt(t,o.first().val())){this.setQuestionTypeSpecificLoadingState(t,false);const e=t.find('[data-glpi-form-editor-on-change="change-question-type-category"]').data("previous-value");if(e!==undefined){t.find('[data-glpi-form-editor-on-change="change-question-type-category"]').val(e).trigger("change.select2")}return false}this.setQuestionTypeSpecificLoadingState(t,false);const n=t.find("[data-glpi-form-editor-question-type-selector]");n.children().remove();this.#mt(o,n);this.#dt(t,"category",e);const a=n.parent();if(o.length<=1){a.addClass("d-none")}else{a.removeClass("d-none")}n.trigger("change")}async#D(t,e){const i=this.#rt(t,"type");if(i===e){return}this.setQuestionTypeSpecificLoadingState(t,true);if(!await this.#vt(t,e)){this.setQuestionTypeSpecificLoadingState(t,false);const e=t.find('[data-glpi-form-editor-on-change="change-question-type"]').data("previous-value");if(e!==undefined){t.find('[data-glpi-form-editor-on-change="change-question-type"]').val(e).trigger("change.select2")}return}this.setQuestionTypeSpecificLoadingState(t,false);const o=this.#a[i].extractDefaultValue(t);const n=t.find("[data-glpi-form-editor-question-type-specific]");n.children().remove();const a=t.find("[data-glpi-form-editor-specific-question-options]");a.children().remove();const s=this.#g(e).find("[data-glpi-form-editor-question-type-specific]").children();const d=this.#g(e).find("[data-glpi-form-editor-specific-question-options]").children();this.#mt(s,n);this.#mt(d,a);this.#dt(t,"type",e);const r=this.#g(e).find("[data-glpi-form-editor-question-details]").data("glpi-form-editor-allow-anonymous");t.find("[data-glpi-form-editor-blacklisted-question-type-warning]").toggleClass("d-none",r==1);this.#a[e].convertDefaultValue(t,o);if(this.#s[e]!==undefined){const i=t.find("[data-glpi-form-editor-question-sub-type-selector]");i.closest("div").removeClass("d-none");i.attr("disabled",false);i.find("optgroup, option").remove();const o=this.#s[e].subtypes;for(const t in o){if(typeof o[t]==="object"){const e=$(`<optgroup label="${_.escape(t)}"></optgroup>`);for(const[i,n]of Object.entries(o[t])){const t=$(`<option value="${_.escape(i)}">${_.escape(n)}</option>`);e.append(t)}i.append(e);continue}const e=$(`<option value="${_.escape(t)}">${_.escape(o[t])}</option>`);i.append(e)}if(this.#s[e].default_value){i.val(this.#s[e].default_value)}i.attr("name",this.#s[e].field_name);i.attr("aria-label",this.#s[e].field_aria_label);i.removeAttr("data-glpi-form-editor-original-name");i.removeData("glpi-form-editor-original-name");i.trigger("change")}else{t.find("[data-glpi-form-editor-question-sub-type-selector]").attr("disabled",true).closest("div").addClass("d-none")}$(document).trigger("glpi-form-editor-question-type-changed",[t,e])}#A(t,e){$(document).trigger("glpi-form-editor-question-sub-type-changed",[t,e])}#x(t){let e;let i;let o;if(t.data("glpi-form-editor-question")!==undefined||t.data("glpi-form-editor-comment")!==undefined){e=t.closest("[data-glpi-form-editor-section]");i="after";o=$(t).nextAll()}else if(t.data("glpi-form-editor-section")!==undefined){e=t.closest("[data-glpi-form-editor-section]");i="after";o=$(t).closest("[data-glpi-form-editor-section]").find("[data-glpi-form-editor-question]")}else if(t.data("glpi-form-editor-form")!==undefined){e=t.closest("[data-glpi-form-editor-form]").find("[data-glpi-form-editor-section]:last-child");i="after";o=null}else if(t.data("glpi-form-editor-horizontal-blocks-container")!==undefined){e=t;i="after";o=$(t).nextAll()}else{throw new Error("Unexpected target")}const n=$(this.#o).find("[data-glpi-form-editor-section-template]").children();const a=this.#mt(n,e,i);if(o!==null&&o.length>0){o.detach().appendTo(a.find("[data-glpi-form-editor-section-blocks]"));o.each((t,e)=>{this.#Ct($(e))})}this.#E(a.find("[data-glpi-form-editor-section-details]"));this.#h(a);a.find("[data-glpi-form-editor-section-details-name]")[0].focus()}#F(t){if(!this.#ft("section",t)){return}const e=t.find("[data-glpi-form-editor-block]");if(e.length>0){const i=this.#rt(t,"uuid");const o=e.map((t,e)=>{const i=$(e);const o=i.is("[data-glpi-form-editor-question]")?"question":"comment";return this.#ut(o,i)}).get().map(t=>{const e=t.conditionsUsingItem.filter((t,e)=>{const o=$(e).closest("[data-glpi-form-editor-section]");const n=this.#rt(o,"uuid");return n!==i});return{conditionsUsingItem:e,destinationsUsingItem:t.destinationsUsingItem,itemUsedBySubmitButton:t.itemUsedBySubmitButton}}).reduce((t,e)=>({conditionsUsingItem:t.conditionsUsingItem.add(e.conditionsUsingItem),destinationsUsingItem:t.destinationsUsingItem.concat(e.destinationsUsingItem),itemUsedBySubmitButton:t.itemUsedBySubmitButton||e.itemUsedBySubmitButton}),{conditionsUsingItem:$(),destinationsUsingItem:[],itemUsedBySubmitButton:false});if(o.conditionsUsingItem.length>0||o.destinationsUsingItem.length>0){this.#bt("section",o.conditionsUsingItem,o.destinationsUsingItem,o.itemUsedBySubmitButton,"section_child_elements_deletion");return}this.#St(t);return}this.#It(t)}#St(t){const e=t.find("[data-glpi-form-editor-block]");let i=0;let o=0;e.each((t,e)=>{const n=$(e);if(n.is("[data-glpi-form-editor-question]")){i++}else if(n.is("[data-glpi-form-editor-comment]")){o++}});const n=[];if(i>0){const t=_n("question","questions",i);n.push(`${i} ${t}`)}if(o>0){const t=_n("comment","comments",o);n.push(`${o} ${t}`)}const a=n.join(` ${__("and")} `);const s=__("Deleting this section will also delete %s. This action cannot be undone.").replace("%s",a);$("[data-glpi-form-editor-delete-section-message]").text(s);$("[data-glpi-form-editor-confirm-delete-section]").off("click").on("click",()=>{$("[data-glpi-form-editor-delete-non-empty-section-modal]").modal("hide");this.#It(t)});$("[data-glpi-form-editor-delete-non-empty-section-modal]").modal("show")}#It(t){if(t.prev().length==0){if(t.next().length>0&&this.#gt()>2){this.#E(t.next())}else{this.#ht()}}else{const e=t.prev().find("[data-glpi-form-editor-question]");if(e.length>0){this.#E(e.last())}else{if(this.#gt()==2){this.#ht()}else{this.#E(t.prev())}}}t.remove();this.#m()}#j(t){const e=$(this.#o).find("[data-glpi-form-editor-comment-template]").children();const i=this.#pt(t,e);this.#tt(i);this.#E(i);i.find("[data-glpi-form-editor-comment-details-name]")[0].focus();this.#h(i)}#N(t){if(!this.#ft("comment",t)){return}t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");if($(this.#t).find("[data-glpi-form-editor-comment]").length==1&&this.#gt()==1){this.#ht()}else{if(t.prev().length>0){this.#E(t.prev())}else{this.#E(t.closest("[data-glpi-form-editor-section]"))}}const e=t.parent();t.remove();if(e.is("[data-glpi-form-editor-horizontal-blocks]")&&e.find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length===0){this.#X(e)}}#ot(){const t=$(this.#t).find("[data-glpi-form-editor-block]").length;if(t==0){$("[data-glpi-form-editor-on-click='add-section']").addClass("d-none")}else{$("[data-glpi-form-editor-on-click='add-section']").removeClass("d-none")}}#gt(){return $(this.#t).find("[data-glpi-form-editor-section]").length}#u(){return $(this.#t).find("[data-glpi-form-editor-question]").length}#at(){if(this.#gt()<=1){$(this.#t).find("[data-glpi-form-editor-section-details]").addClass("d-none")}else{$(this.#t).find("[data-glpi-form-editor-section-details]").removeClass("d-none")}}#st(){$(this.#t).find(`[data-glpi-form-editor-on-click="merge-with-previous-section"]`).removeClass("d-none");$(this.#t).find(`[data-glpi-form-editor-section]:first-child`).find(`[data-glpi-form-editor-on-click="merge-with-previous-section"]`).addClass("d-none")}#h(t){t.each((t,e)=>{const i=$(e).find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]");i.each((t,e)=>{const i=$(e);const o={handle:"[data-glpi-form-editor-question-handle]",items:"[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]",acceptFrom:"[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks]",placeholder:'<section class="glpi-form-editor-drag-question-placeholder"></section>'};if(i.is("[data-glpi-form-editor-horizontal-blocks]")){o.maxItems=4}sortable(i,o)})});t.find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]").on("sortupdate",t=>{this.#w("question-sort-update",null,t)});t.find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]").on("sortstart",t=>{$(t.detail.item).addClass("form-editor-no-merge");setTimeout(()=>{$(t.detail.item).addClass("d-none");if($(t.detail.item).is("[data-glpi-form-editor-active-question],[data-glpi-form-editor-active-comment]")){$(t.detail.item).attr("data-glpi-form-editor-restore-active-state","")}this.#E(null);$(this.#t).addClass("disable-focus").attr("data-glpi-form-editor-sorting","")},0)});t.find("[data-glpi-form-editor-section-blocks], [data-glpi-form-editor-horizontal-blocks], [data-glpi-form-editor-question-drag-merge], [data-glpi-form-editor-horizontal-block-placeholder]").on("sortstop",t=>{if($(t.detail.item).hasClass("sortable-dragging")){return}if($(t.detail.origin.container).data("glpi-form-editor-horizontal-blocks")!==undefined&&$(t.detail.origin.container).find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length===0){this.#X($(t.detail.origin.container).parent("[data-glpi-form-editor-horizontal-blocks-container]"))}if($(t.detail.item).parent().data("glpi-form-editor-horizontal-block-placeholder")!==undefined){const e=$(t.detail.item).parent();$(t.detail.item).insertAfter(e);e.remove()}if($(t.detail.item).parent().data("glpi-form-editor-question-drag-merge")!==undefined){const e=$(t.detail.item).parents("[data-glpi-form-editor-block]").addBack();this.#_t(e)}this.#Ct($(t.detail.item));$(this.#t).removeClass("disable-focus").removeAttr("data-glpi-form-editor-sorting");$(".content-editable-tinymce").removeClass("simulate-focus");const e=$(t.detail.item).attr("data-glpi-form-editor-restore-active-state");if(e!==undefined){$(t.detail.item).removeAttr("data-glpi-form-editor-restore-active-state");this.#E($(t.detail.item))}$(t.detail.item).removeClass("form-editor-no-merge");$(t.detail.item).removeClass("d-none")})}#Q(){const t=$(this.#t).find("[data-glpi-form-editor-move-section-modal-items]");t.children().remove();$(this.#t).find("[data-glpi-form-editor-section]").each((e,i)=>{const o=this.#rt($(i),"name");const n=$("[data-glpi-form-editor-move-section-modal-item-template]").clone();const a=getUUID();$(i).attr("data-glpi-form-editor-move-section-modal-uuid",a);n.find("[data-glpi-form-editor-move-section-modal-item-section-key]").attr("data-glpi-form-editor-move-section-modal-item-section-key",a);n.find("[data-glpi-form-editor-move-section-modal-item-section-key]").attr("aria-label",_.unescape(__("Move section: %1$d")).replace("%1$d",o));n.find("[data-glpi-form-editor-move-section-modal-item-section-name]").text(o);n.removeAttr("data-glpi-form-editor-move-section-modal-item-template");t.append(n)});sortable($("[data-glpi-form-editor-move-section-modal-items]"),{handle:"[data-glpi-form-editor-section-handle]",placeholderClass:"glpi-form-editor-drag-section-placeholder"})}#B(){$(this.#t).find("[data-glpi-form-editor-move-section-modal]").modal("hide");$(this.#t).find("[data-glpi-form-editor-move-section-modal-items]").children().each((t,e)=>{const i=$(e).find("[data-glpi-form-editor-move-section-modal-item-section-key]").data("glpi-form-editor-move-section-modal-item-section-key");const o=$(this.#t).find(`[data-glpi-form-editor-move-section-modal-uuid="${CSS.escape(i)}"]`);o.remove().appendTo($(this.#t).find("[data-glpi-form-editor-blocks]"))});$(this.#t).find("[data-glpi-form-editor-section]").each((t,e)=>{this.#Ct($(e))})}#Ct(t){const e=this.#wt(t);this.#qt(e)}#M(t){const e=t.prev();const i=t.find("[data-glpi-form-editor-section-blocks]").children();i.detach().appendTo(e.find("[data-glpi-form-editor-section-blocks]"));i.each((t,e)=>{this.#Ct($(e))});t.remove()}#V(t){t.toggleClass("section-collapsed");this.#Et(t)}#Et(t){const e=t.find("[data-glpi-form-editor-block]").length;const i=t.find("span[data-glpi-form-editor-section-block-badge]");i.html(i.html().trim().replace(/^\d+\s/,`${e} `))}#H(t){const e=this.#wt(t);const i=this.#mt(t,t,"after",true);this.#qt(e);this.#dt(i,"uuid","");i.find("[data-glpi-form-editor-question]").each((t,e)=>{this.#dt($(e),"uuid","")});this.#E(i);this.#h(i)}#L(t){const e=this.#wt(t);const i=this.#mt(t,t,"after",true);this.#qt(e);this.#dt(i,"uuid","");this.#E(i);t.closest("[data-glpi-form-editor-horizontal-blocks]").find("[data-glpi-form-editor-horizontal-block-placeholder]").first().remove();$(document).trigger("glpi-form-editor-question-duplicated",[t,i])}#O(t){const e=this.#wt(t);const i=this.#mt(t,t,"after");this.#qt(e);this.#dt(i,"uuid","");this.#E(i);t.closest("[data-glpi-form-editor-horizontal-blocks]").find("[data-glpi-form-editor-horizontal-block-placeholder]").first().remove()}#nt(){$(this.#t).find("[data-glpi-form-editor-empty-div]").remove();const t=$(this.#t).find("[data-glpi-form-editor-section]");t.each((t,e)=>{const i=$(e).find("[data-glpi-form-editor-section-blocks]");if(i.children().length==0){i.append('<div data-glpi-form-editor-empty-div style="height: 1px"></div>')}})}#wt(t){const e=[];t.find("textarea").each((t,i)=>{const o=$(i).prop("id");const n=tinymce.get(o);if(n){n.destroy();e.push(o)}});return e}#qt(t){t.forEach(t=>{tinymce.init(window.tinymce_editor_configs[t])})}#S(){if(hasUnsavedChanges()){$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-preview-action]").addClass("d-none");$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-save-and-preview-action]").removeClass("d-none")}else{$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-preview-action]").removeClass("d-none");$(this.#t).find("[data-glpi-form-editor-preview-actions]").find("[data-glpi-form-editor-save-and-preview-action]").addClass("d-none")}}#ht(){const t=$(this.#t).find("[data-glpi-form-editor-form-details]");this.#E(t)}#P(t){t.find("[data-glpi-form-editor-visibility-dropdown-container]").removeClass("d-none");const e=t.find("[data-glpi-form-editor-visibility-dropdown-container]").find("[data-glpi-form-editor-visibility-dropdown]");bootstrap.Dropdown.getOrCreateInstance(e[0]).show()}#I(t,e){let i=null;if(t.find(`[data-glpi-editor-visibility-badge="${CSS.escape(e)}"]`).length>0){i="visibility"}else if(t.find(`[data-glpi-editor-validation-badge="${CSS.escape(e)}"]`).length>0){i="validation"}t.find(`[data-glpi-editor-${CSS.escape(i)}-badge]`).removeClass("d-flex").addClass("d-none");t.find(`[data-glpi-editor-${CSS.escape(i)}-badge="${CSS.escape(e)}"]`).removeClass("d-none").addClass("d-flex")}#_(t,e){t.find("[data-glpi-editor-validation-conditions-count-badge], [data-glpi-editor-visibility-conditions-count-badge]").html(e)}#R(t){t.find("[data-glpi-form-editor-validation-dropdown-container]").removeClass("d-none");const e=t.find("[data-glpi-form-editor-validation-dropdown-container]").find("[data-glpi-form-editor-validation-dropdown]");bootstrap.Dropdown.getOrCreateInstance(e[0]).show()}#zt(){this.computeState();const t=[];$(this.#t).find("[data-glpi-form-editor-section]").each((e,i)=>{t.push({uuid:this.#rt($(i),"uuid"),name:this.#rt($(i),"name")})});return t}#Ut(){this.computeState();const t=[];$(this.#t).find("[data-glpi-form-editor-question]").each((e,i)=>{t.push({uuid:this.#rt($(i),"uuid"),name:this.#rt($(i),"name"),type:this.#rt($(i),"type"),extra_data:this.#yt(i)})});return t}#Tt(){this.computeState();const t=[];$(this.#t).find("[data-glpi-form-editor-comment]").each((e,i)=>{t.push({uuid:this.#rt($(i),"uuid"),name:this.#rt($(i),"name")})});return t}async#k(t){let e=this.#Dt(t);if(e===null){const i=this.#rt(t.closest("[data-glpi-form-editor-block], [data-glpi-form-editor-section-details], [data-glpi-form-editor-container]"),"uuid");const o=t.closest("[data-glpi-form-editor-condition-type]").data("glpi-form-editor-condition-type");e=new GlpiFormConditionVisibilityEditorController(t[0],i,o,this.#zt(),this.#Ut(),this.#Tt());t.attr("data-glpi-editor-condition-controller-index",this.#d.length);this.#d.push(e)}else{e.setFormSections(this.#zt());e.setFormQuestions(this.#Ut());e.setFormComments(this.#Tt())}e.renderEditor()}async#C(t){let e=this.#Dt(t);if(e===null){const i=this.#rt(t.closest("[data-glpi-form-editor-block], [data-glpi-form-editor-section-details], [data-glpi-form-editor-container]"),"uuid");const o=t.closest("[data-glpi-form-editor-condition-type]").data("glpi-form-editor-condition-type");e=new GlpiFormConditionValidationEditorController(t[0],i,o,this.#zt(),this.#Ut(),this.#Tt());t.attr("data-glpi-editor-condition-controller-index",this.#d.length);this.#d.push(e)}else{e.setFormSections(this.#zt());e.setFormQuestions(this.#Ut());e.setFormComments(this.#Tt())}e.renderEditor()}#Dt(t){const e=t.data("glpi-editor-condition-controller-index");return this.#d[e]??null}#b(){$(this.#t).find("[data-glpi-editor-refresh-checked]").removeProp("checked");$(this.#t).find("[data-glpi-editor-refresh-checked]").prop("checked",true)}#G(t){const e=$(this.#o).find("[data-glpi-form-editor-horizontal-block-template]").children();const i=this.#pt(t,e);this.#h(i)}#X(t){t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");const e=t.find("[data-glpi-form-editor-block]");e.insertAfter(t);t.prev("[data-glpi-form-editor-horizontal-blocks-fix-sortable-issue]").remove();t.next("[data-glpi-form-editor-horizontal-blocks-fix-sortable-issue]").remove();t.remove()}#J(t){const e=$(this.#o).find("[data-glpi-form-editor-horizontal-block-placeholder-template]").children();const i=this.#pt(t,e);this.#h(t);this.#E(i);t.find('[data-bs-toggle="tooltip"]').tooltip("dispose")}#W(t){t.find('[data-bs-toggle="tooltip"]').tooltip("dispose");if(t.parent().find("[data-glpi-form-editor-block], [data-glpi-form-editor-horizontal-block-placeholder]").length==1){this.#X(t.parent())}else{t.remove()}}#_t(t){const e=$(this.#o).find("[data-glpi-form-editor-horizontal-block-template]").children();const i=this.#mt(e,t.first(),"after");t.detach().appendTo(i.find("[data-glpi-form-editor-horizontal-blocks]"));this.#h(i);i.find("[data-glpi-form-editor-horizontal-block-placeholder]").remove()}#K(t){this.computeState();const e=this.#rt(t,"uuid");navigator.clipboard.writeText(e);glpi_toast_info(__("UUID copied successfully to clipboard."))}#ct(t){const e={behavior:"smooth",block:"nearest"};t[0].scrollIntoView(e);setTimeout(()=>{t[0].scrollIntoView(e)},100);setTimeout(()=>{t[0].scrollIntoView(e)},200);setTimeout(()=>{t[0].scrollIntoView(e)},500)}}