/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2026 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
export class ProgressIndicator{#e;#s;#r;#t;#a;#i=false;#n=250;#o=-1;constructor({container:e,request:s,success_callback:r=()=>{},error_callback:t=()=>{}}){if(!(e instanceof HTMLElement)){throw new Error(`\`container\` must be an \`HTMLElement\`, "${e?.constructor?.name||typeof e}" found.`)}if(!(s instanceof Request)){throw new Error(`\`request\` must be a \`Request\`, "${s?.constructor?.name||typeof s}" found.`)}this.#s=e;this.#r=s;this.#t=r;this.#a=t}async start(){if(this.#i){throw new Error("Progress indicator must not be started more than once.")}this.#i=true;const e=document.createElement("div");e.innerHTML=`\n        <div class="progress-indicator" style="padding-left: 20px; padding-right: 20px;">\n            <div class="progress" style="height: 15px;">\n                <div class="progress-bar bg-info" role="progressbar" style="width:0;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>\n            </div>\n            <div class="progress-msg-container"></div>\n            <div class="messages-container card text-dark my-3 p-2 d-none"></div>\n        </div>\n        `;this.#s.appendChild(e);const s=await fetch(this.#r);const r=(await s.body.getReader().read()).value;this.#e=(new TextDecoder).decode(r);setTimeout(()=>{this.#c()},this.#n)}#l(e,s,r){const t=e/s*100;const a=this.#s.querySelector(".progress-indicator > .progress > .progress-bar");a.style.width=`${t}%`;a.innerHTML=`${Math.floor(t)} %`;a.setAttribute("aria-valuenow",t);const i=this.#s.querySelector(".progress-indicator > .progress-msg-container");i.innerHTML=_.escape(r.trim()).replace(/\n/gi,"<br>")}#d(){const e=this.#s.querySelector(".progress-indicator > .progress > .progress-bar");e.innerHTML=__("failed");e.classList.remove("bg-info");e.classList.add("bg-danger")}async#c(){try{const e=await fetch(`${CFG_GLPI.root_doc}/progress/check/${this.#e}`);if(e.status>=400){throw new Error(`Error response from server with code "${e.status.toString()}".`)}const s=await e.json();this.#l(s["current_step"],s["max_steps"],s["progress_bar_message"]);for(let e=this.#o+1;e<s["messages"].length;e++){const r=s["messages"][e];if(r.type==="debug"){continue}this.#h(r.type,r.message);this.#o=e}if(s["failed"]===true){this.#a();this.#d();return}if(s["ended_at"]){this.#t();return}setTimeout(()=>{this.#c()},this.#n)}catch(e){this.#h("error",_.unescape(__("An unexpected error occurred")));this.#a();this.#d();throw e}}#h(e,s){let r="";switch(e){case"error":r="ti ti-exclamation-circle-filled text-danger";break;case"warning":r="ti ti-alert-triangle text-warning";break;case"notice":r="ti ti-info-circle text-info";break;case"success":r="ti ti-check text-success";break}const t=document.createElement("div");t.innerHTML=`\n            <i class="${r} align-middle"></i>\n            ${_.escape(s)}\n        `;const a=this.#s.querySelector(".progress-indicator > .messages-container");a.appendChild(t);a.classList.remove("d-none")}}