<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2026 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

namespace Glpi\Controller\Session;

use Glpi\Controller\AbstractController;
use Glpi\Exception\Http\AccessDeniedHttpException;
use Glpi\Http\Firewall;
use Glpi\Http\RedirectResponse;
use Glpi\Security\Attribute\SecurityStrategy;
use Html;
use Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

final class ChangeEntityController extends AbstractController
{
    #[Route(
        "/Session/ChangeEntity",
        name: "glpi_change_entity",
        methods: "POST",
    )]
    #[SecurityStrategy(Firewall::STRATEGY_AUTHENTICATED)]
    public function __invoke(Request $request): Response
    {
        // Read parameters
        $full_structure = $request->request->getBoolean('full_structure');
        $entity_id      = $full_structure ? 'all' : $request->request->getInt('id');
        $is_recursive   = $request->request->getBoolean('is_recursive');

        // Try to load new entity
        if (!Session::changeActiveEntities($entity_id, $is_recursive)) {
            throw new AccessDeniedHttpException();
        }

        // If the profile change was made with an AJAX request, this mean this
        // was some background script and we do not need to redirect it to
        // another page.
        if ($request->isXmlHttpRequest()) {
            return new Response();
        }

        // Redirect to previous page
        $redirect = Html::getBackUrl();
        return new RedirectResponse($redirect);
    }
}
