<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2026 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

namespace Glpi\Exception;

use Exception;
use Glpi\Http\RedirectResponse;

/**
 * @internal Not to be used unless you absolutely know what you are doing.
 *           This will be removed in the future when all the code is under Dependency Injection and proper HTTP routing.
 */
class RedirectException extends Exception
{
    private RedirectResponse $response;

    public function __construct(string $url, int $http_code = 302)
    {
        $this->response = new RedirectResponse($url, $http_code);
    }

    public function getResponse(): RedirectResponse
    {
        return $this->response;
    }
}
