<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2026 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

namespace Glpi\Helpdesk\Tile;

use Glpi\Session\SessionInfo;

interface TileInterface
{
    /**
     * Used to sort tiles in dropdowns.
     * Lowest weight will be displayed first.
     */
    public function getWeight(): int;

    public function getLabel(): string;

    public function getTitle(): string;

    public function getDescription(): string;

    public function getIllustration(): string;

    public function getTileUrl(): string;

    public function isAvailable(SessionInfo $session_info): bool;

    public function getDatabaseId(): int;

    public function getConfigFieldsTemplate(): string;
}
